/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.manager;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.commands.ImpactorCommandManager;
import net.impactdev.impactor.api.commands.events.RegisterBrigadierMappingsEvent;
import net.impactdev.impactor.api.events.ImpactorEvent;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.event.EventBus;
import net.kyori.event.PostResult;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.brigadier.BrigadierManagerHolder;
import org.incendo.cloud.brigadier.BrigadierSetting;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.brigadier.argument.BrigadierMappings;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.handling.ExceptionController;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.minecraft.extras.AudienceProvider;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.processors.cache.GuavaCache;
import org.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import org.incendo.cloud.processors.confirmation.ConfirmationManager;
import org.incendo.cloud.setting.Configurable;
import org.incendo.cloud.setting.Setting;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommandManager
implements ImpactorCommandManager {
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("Impactor Command Executor: %d").setDaemon(true).build());
    protected final PluginMetadata metadata;
    protected final PluginLogger logger;
    private final CommandManager<CommandSource> manager;
    private final ConfirmationManager<CommandSource> confirmations;

    public AbstractCommandManager(PluginMetadata metadata, PluginLogger logger) {
        BrigadierManagerHolder holder;
        this.metadata = metadata;
        this.logger = logger;
        ExecutionCoordinator executor = ExecutionCoordinator.builder().executor((Executor)EXECUTOR).build();
        this.manager = this.create((ExecutionCoordinator<CommandSource>)executor);
        this.confirmations = ConfirmationManager.confirmationManager((ConfirmationConfiguration)ConfirmationConfiguration.builder().cache(GuavaCache.of((Cache)CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build())).noPendingCommandNotifier(source2 -> source2.sendMessage(Component.text((String)"No pending confirmations available...").color((TextColor)NamedTextColor.RED))).confirmationRequiredNotifier((source2, context) -> source2.sendMessage(Component.text((String)"Click to confirm action!").color((TextColor)NamedTextColor.YELLOW))).build());
        this.manager.registerCommandPostProcessor(this.confirmations.createPostprocessor());
        CommandManager<CommandSource> commandManager = this.manager;
        if (commandManager instanceof BrigadierManagerHolder && (holder = (BrigadierManagerHolder)commandManager).hasBrigadierManager()) {
            CloudBrigadierManager brigadier = holder.brigadierManager();
            Configurable settings = brigadier.settings();
            settings.set((Setting)BrigadierSetting.FORCE_EXECUTABLE, true);
            BrigadierMappings mappings = brigadier.mappings();
            EventBus<ImpactorEvent> events = Impactor.instance().events();
            PostResult result = events.post((Object)new RegisterBrigadierMappingsEvent(mappings));
            if (!result.wasSuccessful()) {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.title("Failed to Register Brigadier Mappings");
                printer.add("Stacktraces below...");
                result.exceptions().forEach((subscriber, exception) -> printer.add((Throwable)exception));
                printer.log(logger, PrettyPrinter.Level.ERROR);
            }
        }
    }

    @Override
    public PluginMetadata provider() {
        return this.metadata;
    }

    @Override
    public CommandManager<CommandSource> delegate() {
        return this.manager;
    }

    @Override
    public ConfirmationManager<CommandSource> confirmations() {
        return this.confirmations;
    }

    protected abstract CommandManager<CommandSource> create(ExecutionCoordinator<CommandSource> var1);

    protected void initialize() {
        try {
            ExceptionController controller = this.manager.exceptionController();
            controller.registerHandler(CommandExecutionException.class, context -> {
                TextComponent detail = Component.text((String)"An internal error occurred while attempting to perform this command...");
                detail = detail.color((TextColor)NamedTextColor.RED);
                Style style = detail.style();
                StringWriter writer = new StringWriter();
                ((CommandExecutionException)context.exception()).getCause().printStackTrace(new PrintWriter(writer));
                String trace = writer.toString().replace("\t", Strings.repeat((String)" ", (int)4));
                Component result = ((TextComponent)Component.text((String)trace).append((Component)Component.newline())).append(Component.text((String)"Click to copy!").color((TextColor)NamedTextColor.YELLOW));
                style = style.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)result)).clickEvent(ClickEvent.copyToClipboard((String)trace));
                detail = detail.style(style);
                ((CommandSource)context.context().sender()).sendMessage((Component)detail);
                this.printException((CommandExecutionException)context.exception());
            });
            MinecraftExceptionHandler.create((AudienceProvider)AudienceProvider.nativeAudience()).registerTo(this.manager);
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.logger, e);
        }
    }

    private void printException(CommandExecutionException exception) {
        PrettyPrinter printer = new PrettyPrinter(80).wrapTo(80);
        printer.title("Command Execution Exception").add("An unexpected error was encountered during command processing. This error").consume(p -> {
            String contextual = exception.context() != null ? "alongside its relative context" : "";
            p.add(contextual + " will now be displayed.");
        }).hr('-').consume(p -> {
            @Nullable CommandContext context = exception.context();
            if (context != null) {
                p.add("Command Input: %s", context.rawInput().input());
                p.add("During Suggestions: %b", context.isSuggestions());
                p.add("Context:");
                context.all().forEach((key, value) -> p.add("  %s: %s", key, value.toString()));
                p.newline();
            }
        }).add("Encountered Exception Stacktrace:").add((Throwable)exception);
        printer.log(this.logger, PrettyPrinter.Level.ERROR);
    }
}

